       IDENTIFICATION DIVISION.
      *
      * Relativity Modernization Workbench Reference Implementation COBOL/CICS/VSAM Application
      *
      * Author: Nic Walsh February 2002
      *
      * This program checks integer entries
      *
      *
       PROGRAM-ID.  INTEDIT.
      *
       ENVIRONMENT DIVISION.
      *
       DATA DIVISION.
      *
       WORKING-STORAGE SECTION.
      *
       01  WORK-FIELDS.
      *
           05  INTEGER-PART        PIC 9(5).
           05  INTEGER-LENGTH      PIC S999  COMP-3.
           02  IDC-ID-C-SEQ-C               PIC S9(009)       COMP-3.
           02  IDC-TRANS-PGM-ID-C           PIC X(008).
           02  IDC-EN-N                     PIC X(018).

      *                           SQL COMMUNICATIONS AREA
       01  SQLCODE                          PIC S9(09) COMP.


      *
       LINKAGE SECTION.
      *
       01  UNEDITED-NUMBER         PIC X(5).
      *
       01  EDITED-NUMBER           PIC 9(5).
      *
       01  VALID-NUMBER-SW         PIC X.
           88  VALID-NUMBER        VALUE 'Y'.
      *
       PROCEDURE DIVISION USING UNEDITED-NUMBER
                                EDITED-NUMBER
                                VALID-NUMBER-SW.
      *
       0000-EDIT-NUMBER.
      *
           MOVE ZERO TO INTEGER-LENGTH.
           INSPECT UNEDITED-NUMBER
               REPLACING LEADING SPACE BY ZERO.
           INSPECT UNEDITED-NUMBER
               TALLYING INTEGER-LENGTH FOR CHARACTERS
                   BEFORE INITIAL SPACE.
           IF UNEDITED-NUMBER(1:INTEGER-LENGTH) NUMERIC
               MOVE UNEDITED-NUMBER(1:INTEGER-LENGTH)
                   TO EDITED-NUMBER
               MOVE 'Y' TO VALID-NUMBER-SW
           ELSE
               MOVE 'N' TO VALID-NUMBER-SW.
      *
       0000-EXIT.
      *

      *
       0001-SELECT.
      *     
           EXEC SQL
            SELECT
             ID_C_SEQ_C,
             TRANS_PGM_ID_C
            INTO
             :IDC-ID-C-SEQ-C,
             :IDC-TRANS-PGM-ID-C
            FROM PS_ID_C

            WHERE  EN_N = :IDC-EN-N

           END-EXEC.
      *
       0001-EXIT.
      *

      *
       0002-SELECT.
      *    
           EXEC SQL
            SELECT
             TRANS_PGM_ID_C
            INTO
             :IDC-TRANS-PGM-ID-C
            FROM PS_ID_C

            WHERE  EN_N = :IDC-EN-N

           END-EXEC.
      *
       0002-EXIT.
      *

           EXIT PROGRAM.
